package gov.va.vamf.scheduling.varutility.service;

import gov.va.vamf.scheduling.varutility.domain.ClinicalServices;
import gov.va.vamf.scheduling.varutility.domain.CustomRequestSettings;
import gov.va.vamf.scheduling.varutility.domain.StopCodes;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import static org.junit.Assert.assertEquals;

@ContextConfiguration(locations = { "classpath:applicationContext-test.xml" })
@RunWith(SpringJUnit4ClassRunner.class)
public class CustomRequestSettingsTest {

    CustomRequestSettingsService customRequestSettingsService;

    List<ClinicalServices> clinicalServices;

    @Before
    public void setup() {
        clinicalServices = createClinicalServicesForCustomRequest();
        customRequestSettingsService = new CustomRequestSettingsService();
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testCreateDefaultCustomRequestSettings() {
        CustomRequestSettings customRequestSettings = customRequestSettingsService.createDefaultCustomRequestSettings(clinicalServices);
        assertEquals(customRequestSettings.size(), clinicalServices.size());
    }

    @Test
    public void testUpdateCriteriaCustomRequestSettings() {
        CustomRequestSettings customRequestSettings = customRequestSettingsService.createDefaultCustomRequestSettings(clinicalServices);
        assertEquals(customRequestSettings.get(0).getTypeOfCare(), "Express Care");
        ClinicalServices clinicalService = clinicalServices.get(0);
        clinicalService.setName("Express Care Updated");
        CustomRequestSettings updatedCustomRequestSettings = customRequestSettingsService.updateCriteriaCoreSettings(customRequestSettings, clinicalServices);
        assertEquals(updatedCustomRequestSettings.get(0).getTypeOfCare(), "Express Care Updated");
    }

    private List<ClinicalServices> createClinicalServicesForCustomRequest() {
        List<ClinicalServices> clinicalServicesList = new ArrayList<ClinicalServices>();
        ClinicalServices cs = new ClinicalServices();
        cs.setId("CR1");
        cs.setName("Express Care");
        cs.setCreatedBy("Test User");
        cs.setCreatedDate(new Date());
        cs.setSubmittedRequestLimit(1);
        StopCodes stopCodes = new StopCodes();
        cs.setStopCodes(stopCodes);
        clinicalServicesList.add(cs);
        return clinicalServicesList;
    }
}
